<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= SITE_NAME ?> - AI-Powered Application Generator</title>
    <meta name="description" content="Build complete web applications using AI. No coding required. Generate professional websites, e-commerce stores, and business applications instantly.">
    <link rel="stylesheet" href="assets/css/style.css">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar">
        <div class="container">
            <div class="nav-brand">
                <i class="fas fa-magic"></i>
                <span><?= SITE_NAME ?></span>
            </div>
            <div class="nav-links">
                <a href="#features">Features</a>
                <a href="#templates">Templates</a>
                <a href="#pricing">Pricing</a>
                <a href="?page=login" class="btn-nav">Login</a>
                <a href="?page=register" class="btn-primary">Get Started</a>
            </div>
            <div class="nav-toggle">
                <i class="fas fa-bars"></i>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero">
        <div class="container">
            <div class="hero-content">
                <h1 class="hero-title">
                    Build Complete Applications with <span class="gradient-text">AI Power</span>
                </h1>
                <p class="hero-description">
                    Transform your ideas into professional web applications instantly. Our AI-powered platform generates 
                    complete, production-ready code for e-commerce stores, blogs, corporate websites, and more.
                </p>
                <div class="hero-actions">
                    <a href="?page=register" class="btn-hero">
                        <i class="fas fa-rocket"></i>
                        Start Building Now
                    </a>
                    <a href="#demo" class="btn-secondary">
                        <i class="fas fa-play"></i>
                        Watch Demo
                    </a>
                </div>
                <div class="hero-stats">
                    <div class="stat">
                        <span class="stat-number">10K+</span>
                        <span class="stat-label">Apps Generated</span>
                    </div>
                    <div class="stat">
                        <span class="stat-number">500+</span>
                        <span class="stat-label">Happy Customers</span>
                    </div>
                    <div class="stat">
                        <span class="stat-number">99%</span>
                        <span class="stat-label">Uptime</span>
                    </div>
                </div>
            </div>
            <div class="hero-visual">
                <div class="code-preview">
                    <div class="code-header">
                        <div class="code-dots">
                            <span></span>
                            <span></span>
                            <span></span>
                        </div>
                        <span class="code-title">ai-generator.php</span>
                    </div>
                    <div class="code-content">
                        <pre><code>// AI Generated E-commerce Store
&lt;?php
$products = [
    'id' => 1,
    'name' => 'Premium Widget',
    'price' => 99.99,
    'description' => 'Amazing product',
    'category' => 'electronics'
];

echo renderProduct($products);
?&gt;</code></pre>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features Section -->
    <section id="features" class="features">
        <div class="container">
            <div class="section-header">
                <h2>Powerful Features for Every Need</h2>
                <p>Everything you need to create professional applications without coding</p>
            </div>
            <div class="features-grid">
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-robot"></i>
                    </div>
                    <h3>AI-Powered Generation</h3>
                    <p>Advanced AI models understand your requirements and generate complete, production-ready applications.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-code"></i>
                    </div>
                    <h3>Clean Code Output</h3>
                    <p>Get well-structured, commented, and optimized code that follows industry best practices.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-layer-group"></i>
                    </div>
                    <h3>Multiple Templates</h3>
                    <p>Choose from pre-built templates for e-commerce, blogs, portfolios, and corporate websites.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-download"></i>
                    </div>
                    <h3>Multiple Export Options</h3>
                    <p>Download as ZIP, deploy to GitHub, or publish directly to your hosting account.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-mobile-alt"></i>
                    </div>
                    <h3>Mobile Responsive</h3>
                    <p>All generated applications are fully responsive and work perfectly on all devices.</p>
                </div>
                <div class="feature-card">
                    <div class="feature-icon">
                        <i class="fas fa-lightning-bolt"></i>
                    </div>
                    <h3>Lightning Fast</h3>
                    <p>Generate complete applications in minutes, not hours. No more waiting for developers.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Templates Section -->
    <section id="templates" class="templates">
        <div class="container">
            <div class="section-header">
                <h2>Ready-to-Use Templates</h2>
                <p>Start with professionally designed templates and customize them with AI</p>
            </div>
            <div class="templates-grid">
                <div class="template-card">
                    <div class="template-preview">
                        <i class="fas fa-shopping-cart"></i>
                    </div>
                    <h3>E-commerce Store</h3>
                    <p>Complete online store with product catalog, shopping cart, and payment integration.</p>
                    <span class="template-tag premium">Premium</span>
                </div>
                <div class="template-card">
                    <div class="template-preview">
                        <i class="fas fa-blog"></i>
                    </div>
                    <h3>Blog Platform</h3>
                    <p>Modern blog with content management, SEO optimization, and social sharing.</p>
                    <span class="template-tag premium">Premium</span>
                </div>
                <div class="template-card">
                    <div class="template-preview">
                        <i class="fas fa-building"></i>
                    </div>
                    <h3>Corporate Website</h3>
                    <p>Professional business website with services, about, and contact pages.</p>
                    <span class="template-tag free">Free</span>
                </div>
                <div class="template-card">
                    <div class="template-preview">
                        <i class="fas fa-user-tie"></i>
                    </div>
                    <h3>Portfolio</h3>
                    <p>Creative portfolio for designers, developers, and freelancers.</p>
                    <span class="template-tag free">Free</span>
                </div>
                <div class="template-card">
                    <div class="template-preview">
                        <i class="fas fa-chart-line"></i>
                    </div>
                    <h3>Landing Page</h3>
                    <p>High-converting landing page with call-to-action optimization.</p>
                    <span class="template-tag free">Free</span>
                </div>
                <div class="template-card">
                    <div class="template-preview">
                        <i class="fas fa-calendar-alt"></i>
                    </div>
                    <h3>Event Platform</h3>
                    <p>Event registration and management system with ticket booking.</p>
                    <span class="template-tag premium">Premium</span>
                </div>
            </div>
            <div class="templates-cta">
                <a href="?page=register" class="btn-primary">View All Templates</a>
            </div>
        </div>
    </section>

    <!-- How It Works -->
    <section class="how-it-works">
        <div class="container">
            <div class="section-header">
                <h2>How It Works</h2>
                <p>Create professional applications in three simple steps</p>
            </div>
            <div class="steps">
                <div class="step">
                    <div class="step-number">1</div>
                    <div class="step-content">
                        <h3>Describe Your Idea</h3>
                        <p>Tell our AI what kind of application you want to build. Be as detailed or as simple as you like.</p>
                    </div>
                </div>
                <div class="step">
                    <div class="step-number">2</div>
                    <div class="step-content">
                        <h3>AI Generates Code</h3>
                        <p>Our advanced AI analyzes your requirements and generates complete, production-ready code.</p>
                    </div>
                </div>
                <div class="step">
                    <div class="step-number">3</div>
                    <div class="step-content">
                        <h3>Download & Deploy</h3>
                        <p>Get your application as a ZIP file, deploy to GitHub, or publish directly to your hosting.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Pricing Section -->
    <section id="pricing" class="pricing">
        <div class="container">
            <div class="section-header">
                <h2>Choose Your Plan</h2>
                <p>Flexible pricing for individuals and businesses of all sizes</p>
            </div>
            <div class="pricing-grid">
                <div class="pricing-card">
                    <h3>Free</h3>
                    <div class="price">
                        <span class="currency">$</span>
                        <span class="amount">0</span>
                        <span class="period">/month</span>
                    </div>
                    <ul class="features">
                        <li><i class="fas fa-check"></i> 3 projects</li>
                        <li><i class="fas fa-check"></i> 10 AI generations</li>
                        <li><i class="fas fa-check"></i> Basic templates</li>
                        <li><i class="fas fa-check"></i> Community support</li>
                        <li><i class="fas fa-times"></i> Premium features</li>
                    </ul>
                    <a href="?page=register" class="btn-outline">Get Started</a>
                </div>
                
                <div class="pricing-card popular">
                    <div class="popular-badge">Most Popular</div>
                    <h3>Pro</h3>
                    <div class="price">
                        <span class="currency">$</span>
                        <span class="amount">29</span>
                        <span class="period">/month</span>
                    </div>
                    <ul class="features">
                        <li><i class="fas fa-check"></i> 500 projects</li>
                        <li><i class="fas fa-check"></i> 5,000 AI generations</li>
                        <li><i class="fas fa-check"></i> All templates</li>
                        <li><i class="fas fa-check"></i> Priority support</li>
                        <li><i class="fas fa-check"></i> GitHub integration</li>
                        <li><i class="fas fa-check"></i> Custom domains</li>
                    </ul>
                    <a href="?page=register" class="btn-primary">Start Free Trial</a>
                </div>
                
                <div class="pricing-card">
                    <h3>Enterprise</h3>
                    <div class="price">
                        <span class="currency">$</span>
                        <span class="amount">99</span>
                        <span class="period">/month</span>
                    </div>
                    <ul class="features">
                        <li><i class="fas fa-check"></i> Unlimited projects</li>
                        <li><i class="fas fa-check"></i> Unlimited AI generations</li>
                        <li><i class="fas fa-check"></i> White-label solution</li>
                        <li><i class="fas fa-check"></i> Dedicated support</li>
                        <li><i class="fas fa-check"></i> Custom integrations</li>
                        <li><i class="fas fa-check"></i> API access</li>
                    </ul>
                    <a href="?page=register" class="btn-outline">Contact Sales</a>
                </div>
            </div>
        </div>
    </section>

    <!-- Testimonials -->
    <section class="testimonials">
        <div class="container">
            <div class="section-header">
                <h2>What Our Customers Say</h2>
                <p>Join thousands of satisfied users who have transformed their ideas into reality</p>
            </div>
            <div class="testimonials-grid">
                <div class="testimonial">
                    <div class="testimonial-content">
                        <p>"This platform saved me weeks of development time. I was able to launch my e-commerce store in just one day!"</p>
                    </div>
                    <div class="testimonial-author">
                        <div class="author-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="author-info">
                            <h4>Sarah Johnson</h4>
                            <p>Fashion Designer</p>
                        </div>
                    </div>
                </div>
                <div class="testimonial">
                    <div class="testimonial-content">
                        <p>"The AI code quality is incredible. It's production-ready and follows all best practices."</p>
                    </div>
                    <div class="testimonial-author">
                        <div class="author-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="author-info">
                            <h4>Mike Chen</h4>
                            <p>Startup Founder</p>
                        </div>
                    </div>
                </div>
                <div class="testimonial">
                    <div class="testimonial-content">
                        <p>"Perfect for non-technical entrepreneurs. I built my entire business website without writing a single line of code."</p>
                    </div>
                    <div class="testimonial-author">
                        <div class="author-avatar">
                            <i class="fas fa-user"></i>
                        </div>
                        <div class="author-info">
                            <h4>Emma Davis</h4>
                            <p>Marketing Consultant</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- CTA Section -->
    <section class="cta">
        <div class="container">
            <div class="cta-content">
                <h2>Ready to Build Your Application?</h2>
                <p>Join thousands of users who have already started building with AI. Get started for free today.</p>
                <div class="cta-actions">
                    <a href="?page=register" class="btn-hero">
                        <i class="fas fa-rocket"></i>
                        Start Building Now
                    </a>
                    <span class="cta-note">No credit card required • 7-day free trial</span>
                </div>
            </div>
        </div>
    </section>

    <!-- Footer -->
    <footer class="footer">
        <div class="container">
            <div class="footer-content">
                <div class="footer-section">
                    <div class="footer-brand">
                        <i class="fas fa-magic"></i>
                        <span><?= SITE_NAME ?></span>
                    </div>
                    <p>AI-powered application generator for everyone. Build professional applications without coding.</p>
                    <div class="social-links">
                        <a href="#"><i class="fab fa-twitter"></i></a>
                        <a href="#"><i class="fab fa-linkedin"></i></a>
                        <a href="#"><i class="fab fa-github"></i></a>
                        <a href="#"><i class="fab fa-facebook"></i></a>
                    </div>
                </div>
                <div class="footer-section">
                    <h4>Product</h4>
                    <ul>
                        <li><a href="#features">Features</a></li>
                        <li><a href="#templates">Templates</a></li>
                        <li><a href="#pricing">Pricing</a></li>
                        <li><a href="#">API</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h4>Company</h4>
                    <ul>
                        <li><a href="#">About</a></li>
                        <li><a href="#">Blog</a></li>
                        <li><a href="#">Careers</a></li>
                        <li><a href="#">Contact</a></li>
                    </ul>
                </div>
                <div class="footer-section">
                    <h4>Support</h4>
                    <ul>
                        <li><a href="#">Help Center</a></li>
                        <li><a href="#">Documentation</a></li>
                        <li><a href="#">Privacy Policy</a></li>
                        <li><a href="#">Terms of Service</a></li>
                    </ul>
                </div>
            </div>
            <div class="footer-bottom">
                <p>&copy; 2025 <?= COMPANY_NAME ?>. All rights reserved.</p>
            </div>
        </div>
    </footer>

    <script src="assets/js/main.js"></script>
</body>
</html>