<?php
// Database Setup Step
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $db_host = trim($_POST['db_host'] ?? '');
    $db_name = trim($_POST['db_name'] ?? '');
    $db_user = trim($_POST['db_user'] ?? '');
    $db_pass = trim($_POST['db_pass'] ?? '');
    
    // Validate inputs
    $errors = [];
    if (empty($db_host)) $errors[] = "Database host is required";
    if (empty($db_name)) $errors[] = "Database name is required";
    if (empty($db_user)) $errors[] = "Database username is required";
    
    if (empty($errors)) {
        // Test database connection
        try {
            $dsn = "mysql:host={$db_host};charset=utf8mb4";
            $pdo = new PDO($dsn, $db_user, $db_pass, [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
            ]);
            
            // Create database if it doesn't exist
            $pdo->exec("CREATE DATABASE IF NOT EXISTS `{$db_name}` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
            
            // Store database info in session for next step
            $_SESSION['install_db'] = [
                'host' => $db_host,
                'name' => $db_name,
                'user' => $db_user,
                'pass' => $db_pass
            ];
            
            header('Location: ?step=4&success=Database+connection+successful');
            exit;
            
        } catch (PDOException $e) {
            $connection_error = "Database connection failed: " . $e->getMessage();
        }
    } else {
        $connection_error = implode('<br>', $errors);
    }
}

$success = $_GET['success'] ?? '';
$connection_error = $connection_error ?? '';
?>
<h2>Database Configuration</h2>
<p>Set up your MySQL database connection. You'll need to create a database and user through your hosting control panel first.</p>

<div class="alert alert-info">
    <h4><i class="fas fa-info-circle"></i> How to create a database in cPanel:</h4>
    <ol style="margin-top: 0.5rem; text-align: left;">
        <li>Login to your hosting control panel (cPanel)</li>
        <li>Find "MySQL Databases" or "Database Manager"</li>
        <li>Create a new database (e.g., "youruser_aiapp")</li>
        <li>Create a database user with full privileges</li>
        <li>Add the user to the database</li>
        <li>Note down the host (usually "localhost")</li>
    </ol>
</div>

<?php if ($success): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i> <?php echo htmlspecialchars($success); ?>
    </div>
<?php endif; ?>

<?php if ($connection_error): ?>
    <div class="alert alert-error">
        <i class="fas fa-exclamation-circle"></i> <?php echo $connection_error; ?>
    </div>
<?php endif; ?>

<form method="POST">
    <div class="form-group">
        <label for="db_host">
            <i class="fas fa-server"></i> Database Host
        </label>
        <input type="text" id="db_host" name="db_host" value="<?php echo htmlspecialchars($_POST['db_host'] ?? 'localhost'); ?>" required>
        <small style="color: #6B7280;">Usually "localhost" for shared hosting</small>
    </div>
    
    <div class="form-group">
        <label for="db_name">
            <i class="fas fa-database"></i> Database Name
        </label>
        <input type="text" id="db_name" name="db_name" value="<?php echo htmlspecialchars($_POST['db_name'] ?? ''); ?>" required>
        <small style="color: #6B7280;">The database you created in cPanel</small>
    </div>
    
    <div class="form-group">
        <label for="db_user">
            <i class="fas fa-user"></i> Database Username
        </label>
        <input type="text" id="db_user" name="db_user" value="<?php echo htmlspecialchars($_POST['db_user'] ?? ''); ?>" required>
        <small style="color: #6B7280;">The database user you created</small>
    </div>
    
    <div class="form-group">
        <label for="db_pass">
            <i class="fas fa-key"></i> Database Password
        </label>
        <input type="password" id="db_pass" name="db_pass" value="<?php echo htmlspecialchars($_POST['db_pass'] ?? ''); ?>" required>
        <small style="color: #6B7280;">The password for your database user</small>
    </div>
    
    <div class="btn-group">
        <a href="?step=2" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Back
        </a>
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-database"></i> Test Connection
        </button>
    </div>
</form>

<div style="margin-top: 2rem; padding: 1rem; background: #F8FAFC; border-radius: 8px; font-size: 0.9rem;">
    <h5><i class="fas fa-shield-alt"></i> Security Tips:</h5>
    <ul style="margin-top: 0.5rem;">
        <li>• Use a strong password for your database user</li>
        <li>• Never share your database credentials</li>
        <li>• Regularly backup your database</li>
        <li>• Use SSL for database connections (if available)</li>
    </ul>
</div>