<?php
// Configuration Step
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Get form data
    $admin_email = trim($_POST['admin_email'] ?? '');
    $admin_password = trim($_POST['admin_password'] ?? '');
    $admin_confirm = trim($_POST['admin_confirm'] ?? '');
    $site_name = trim($_POST['site_name'] ?? '');
    $site_url = trim($_POST['site_url'] ?? '');
    $app_url = trim($_POST['app_url'] ?? '');
    $ai_provider = $_POST['ai_provider'] ?? 'openai';
    $ai_api_key = trim($_POST['ai_api_key'] ?? '');
    
    // Validate inputs
    $errors = [];
    if (empty($admin_email) || !filter_var($admin_email, FILTER_VALIDATE_EMAIL)) {
        $errors[] = "Valid admin email is required";
    }
    if (strlen($admin_password) < 6) {
        $errors[] = "Admin password must be at least 6 characters";
    }
    if ($admin_password !== $admin_confirm) {
        $errors[] = "Passwords do not match";
    }
    if (empty($site_name)) {
        $errors[] = "Site name is required";
    }
    
    if (empty($errors)) {
        try {
            // Get database info from session
            if (!isset($_SESSION['install_db'])) {
                header('Location: ?step=3');
                exit;
            }
            
            $db_info = $_SESSION['install_db'];
            
            // Create database connection
            $dsn = "mysql:host={$db_info['host']};dbname={$db_info['name']};charset=utf8mb4";
            $pdo = new PDO($dsn, $db_info['user'], $db_info['pass'], [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
            ]);
            
            // Create tables
            $sql = file_get_contents(__DIR__ . '/../database/schema.sql');
            $pdo->exec($sql);
            
            // Create admin user
            $admin_hash = password_hash($admin_password, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("INSERT INTO users (email, password, name, role, is_active, created_at) VALUES (?, ?, ?, 'admin', 1, NOW())");
            $stmt->execute([$admin_email, $admin_hash, 'Administrator']);
            
            // Create configuration file
            $config_content = "<?php
/**
 * Configuration File - Generated by Installation Wizard
 */

define('DB_HOST', '{$db_info['host']}');
define('DB_NAME', '{$db_info['name']}');
define('DB_USER', '{$db_info['user']}');
define('DB_PASS', '{$db_info['pass']}');
define('DB_CHARSET', 'utf8mb4');

// Application Settings
define('APP_NAME', '" . addslashes($site_name) . "');
define('APP_VERSION', '1.0.0');
define('APP_URL', '" . addslashes($app_url) . "');
define('APP_DIR', __DIR__);

// Security Settings
define('ENCRYPTION_KEY', '" . bin2hex(random_bytes(16)) . "');
define('SESSION_TIMEOUT', 3600);
define('MAX_UPLOAD_SIZE', 50 * 1024 * 1024);

// AI API Configuration
define('OPENAI_API_KEY', '" . addslashes($ai_api_key) . "');
define('CLAUDE_API_KEY', '');
define('DEFAULT_AI_PROVIDER', '{$ai_provider}');

// File Upload Settings
define('UPLOAD_DIR', APP_DIR . '/uploads/');
define('PROJECTS_DIR', APP_DIR . '/projects/');
define('TEMPLATES_DIR', APP_DIR . '/templates/');

// Email Settings (customize these)
define('SMTP_HOST', 'localhost');
define('SMTP_PORT', 587);
define('SMTP_USER', 'noreply@' . parse_url($app_url, PHP_URL_HOST));
define('SMTP_PASS', '');
define('FROM_EMAIL', 'noreply@' . parse_url($app_url, PHP_URL_HOST));
define('FROM_NAME', '" . addslashes($site_name) . "');

// Development Mode
define('DEBUG_MODE', false);

// Timezone
date_default_timezone_set('UTC');

// Create necessary directories
if (!is_dir(UPLOAD_DIR)) {
    mkdir(UPLOAD_DIR, 0755, true);
}
if (!is_dir(PROJECTS_DIR)) {
    mkdir(PROJECTS_DIR, 0755, true);
}
if (!is_dir(TEMPLATES_DIR)) {
    mkdir(TEMPLATES_DIR, 0755, true);
}
?>";
            
            file_put_contents(__DIR__ . '/../config/config.php', $config_content);
            
            // Store admin info for next step
            $_SESSION['install_admin'] = [
                'email' => $admin_email,
                'site_name' => $site_name,
                'app_url' => $app_url
            ];
            
            header('Location: ?step=5&success=Configuration+completed+successfully');
            exit;
            
        } catch (Exception $e) {
            $config_error = "Configuration failed: " . $e->getMessage();
        }
    } else {
        $config_error = implode('<br>', $errors);
    }
}

$success = $_GET['success'] ?? '';
$config_error = $config_error ?? '';
$site_url = 'https://' . ($_SERVER['HTTP_HOST'] ?? 'yourdomain.com') . '/ai-app-generator';
?>
<h2>Application Configuration</h2>
<p>Configure your AI App Generator with basic settings and admin credentials.</p>

<?php if ($success): ?>
    <div class="alert alert-success">
        <i class="fas fa-check-circle"></i> <?php echo htmlspecialchars($success); ?>
    </div>
<?php endif; ?>

<?php if ($config_error): ?>
    <div class="alert alert-error">
        <i class="fas fa-exclamation-circle"></i> <?php echo $config_error; ?>
    </div>
<?php endif; ?>

<form method="POST">
    <h3><i class="fas fa-user-shield"></i> Admin Account</h3>
    <div class="form-group">
        <label for="admin_email">
            <i class="fas fa-envelope"></i> Admin Email
        </label>
        <input type="email" id="admin_email" name="admin_email" value="<?php echo htmlspecialchars($_POST['admin_email'] ?? ''); ?>" required>
        <small style="color: #6B7280;">Your login email for the admin panel</small>
    </div>
    
    <div class="form-group">
        <label for="admin_password">
            <i class="fas fa-lock"></i> Admin Password
        </label>
        <input type="password" id="admin_password" name="admin_password" value="<?php echo htmlspecialchars($_POST['admin_password'] ?? ''); ?>" required>
        <small style="color: #6B7280;">Minimum 6 characters</small>
    </div>
    
    <div class="form-group">
        <label for="admin_confirm">
            <i class="fas fa-lock"></i> Confirm Password
        </label>
        <input type="password" id="admin_confirm" name="admin_confirm" value="<?php echo htmlspecialchars($_POST['admin_confirm'] ?? ''); ?>" required>
    </div>
    
    <h3 style="margin-top: 2rem;"><i class="fas fa-globe"></i> Site Settings</h3>
    <div class="form-group">
        <label for="site_name">
            <i class="fas fa-tag"></i> Site Name
        </label>
        <input type="text" id="site_name" name="site_name" value="<?php echo htmlspecialchars($_POST['site_name'] ?? 'AI App Generator'); ?>" required>
        <small style="color: #6B7280;">The name that will appear in your application</small>
    </div>
    
    <div class="form-group">
        <label for="app_url">
            <i class="fas fa-link"></i> Application URL
        </label>
        <input type="url" id="app_url" name="app_url" value="<?php echo htmlspecialchars($_POST['app_url'] ?? $site_url); ?>" required>
        <small style="color: #6B7280;">The full URL where your app will be accessible</small>
    </div>
    
    <h3 style="margin-top: 2rem;"><i class="fas fa-brain"></i> AI Configuration</h3>
    <div class="form-group">
        <label for="ai_provider">
            <i class="fas fa-robot"></i> AI Provider
        </label>
        <select id="ai_provider" name="ai_provider" required>
            <option value="openai" <?php echo ($_POST['ai_provider'] ?? 'openai') === 'openai' ? 'selected' : ''; ?>>OpenAI (GPT-4)</option>
            <option value="claude" <?php echo ($_POST['ai_provider'] ?? '') === 'claude' ? 'selected' : ''; ?>>Anthropic Claude</option>
            <option value="mock" <?php echo ($_POST['ai_provider'] ?? '') === 'mock' ? 'selected' : ''; ?>>Mock AI (No API required)</option>
        </select>
    </div>
    
    <div class="form-group">
        <label for="ai_api_key">
            <i class="fas fa-key"></i> API Key
        </label>
        <input type="password" id="ai_api_key" name="ai_api_key" value="<?php echo htmlspecialchars($_POST['ai_api_key'] ?? ''); ?>" required>
        <small style="color: #6B7280;">
            <?php if (($_POST['ai_provider'] ?? 'openai') === 'openai'): ?>
                Your OpenAI API key. Get it from <a href="https://platform.openai.com/api-keys" target="_blank">OpenAI</a>
            <?php elseif (($_POST['ai_provider'] ?? '') === 'claude'): ?>
                Your Anthropic Claude API key. Get it from <a href="https://console.anthropic.com/" target="_blank">Anthropic</a>
            <?php else: ?>
                Leave empty if using Mock AI
            <?php endif; ?>
        </small>
    </div>
    
    <div class="btn-group">
        <a href="?step=3" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Back
        </a>
        <button type="submit" class="btn btn-primary">
            <i class="fas fa-cog"></i> Complete Configuration
        </button>
    </div>
</form>

<div style="margin-top: 2rem; padding: 1rem; background: #F8FAFC; border-radius: 8px; font-size: 0.9rem;">
    <h5><i class="fas fa-shield-alt"></i> Security & Performance Tips:</h5>
    <ul style="margin-top: 0.5rem;">
        <li>• Use a strong, unique password for your admin account</li>
        <li>• Keep your AI API key secure and never share it</li>
        <li>• Enable SSL/HTTPS for your domain (recommended)</li>
        <li>• Regularly backup your database and uploaded files</li>
        <li>• Monitor your API usage to control costs</li>
    </ul>
</div>