<?php
/**
 * Installation Wizard
 * Step-by-step setup for shared hosting environments
 */

// Handle different installation steps
$step = $_GET['step'] ?? 1;
$error = $_GET['error'] ?? '';
$success = $_GET['success'] ?? '';

// Prevent access after installation
if (file_exists(__DIR__ . '/../config/.installed') && $step != 'complete') {
    header('Location: ../index.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Installation Wizard - AI App Generator</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #333;
        }
        
        .installer-container {
            background: white;
            border-radius: 16px;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
            max-width: 600px;
            width: 90%;
            overflow: hidden;
        }
        
        .installer-header {
            background: #3B82F6;
            color: white;
            padding: 2rem;
            text-align: center;
        }
        
        .installer-header h1 {
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }
        
        .installer-header p {
            opacity: 0.9;
        }
        
        .step-indicator {
            display: flex;
            justify-content: center;
            padding: 2rem;
            background: #F8FAFC;
        }
        
        .step {
            display: flex;
            align-items: center;
            margin: 0 1rem;
            position: relative;
        }
        
        .step-number {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #E5E7EB;
            color: #6B7280;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            margin-right: 0.75rem;
        }
        
        .step.active .step-number {
            background: #3B82F6;
            color: white;
        }
        
        .step.completed .step-number {
            background: #10B981;
            color: white;
        }
        
        .installer-content {
            padding: 2rem;
        }
        
        .form-group {
            margin-bottom: 1.5rem;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 500;
            color: #374151;
        }
        
        .form-group input,
        .form-group select,
        .form-group textarea {
            width: 100%;
            padding: 0.75rem;
            border: 2px solid #D1D5DB;
            border-radius: 8px;
            font-size: 1rem;
            transition: border-color 0.3s;
        }
        
        .form-group input:focus,
        .form-group select:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: #3B82F6;
        }
        
        .btn {
            display: inline-block;
            padding: 0.75rem 1.5rem;
            border: none;
            border-radius: 8px;
            text-decoration: none;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            font-size: 1rem;
            text-align: center;
        }
        
        .btn-primary {
            background: #3B82F6;
            color: white;
        }
        
        .btn-primary:hover {
            background: #1D4ED8;
        }
        
        .btn-secondary {
            background: #6B7280;
            color: white;
        }
        
        .btn-secondary:hover {
            background: #4B5563;
        }
        
        .btn-group {
            display: flex;
            gap: 1rem;
            justify-content: space-between;
            margin-top: 2rem;
        }
        
        .alert {
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1rem;
        }
        
        .alert-success {
            background: #D1FAE5;
            color: #065F46;
            border: 1px solid #A7F3D0;
        }
        
        .alert-error {
            background: #FEE2E2;
            color: #991B1B;
            border: 1px solid #FECACA;
        }
        
        .alert-info {
            background: #DBEAFE;
            color: #1E40AF;
            border: 1px solid #93C5FD;
        }
        
        .requirements {
            list-style: none;
        }
        
        .requirements li {
            padding: 0.5rem 0;
            display: flex;
            align-items: center;
        }
        
        .requirements .check {
            color: #10B981;
            margin-right: 0.5rem;
        }
        
        .requirements .cross {
            color: #EF4444;
            margin-right: 0.5rem;
        }
        
        .config-preview {
            background: #F3F4F6;
            padding: 1rem;
            border-radius: 8px;
            font-family: 'Courier New', monospace;
            font-size: 0.9rem;
            white-space: pre-wrap;
            margin-top: 1rem;
        }
        
        .welcome-text {
            text-align: center;
            padding: 2rem 0;
        }
        
        .welcome-text h2 {
            color: #3B82F6;
            margin-bottom: 1rem;
        }
        
        .welcome-text p {
            color: #6B7280;
            line-height: 1.6;
            margin-bottom: 1rem;
        }
    </style>
</head>
<body>
    <div class="installer-container">
        <div class="installer-header">
            <h1><i class="fas fa-magic"></i> AI App Generator</h1>
            <p>Installation Wizard</p>
        </div>
        
        <div class="step-indicator">
            <div class="step <?php echo $step >= 1 ? 'active' : ''; ?> <?php echo $step > 1 ? 'completed' : ''; ?>">
                <div class="step-number">1</div>
                <span>Welcome</span>
            </div>
            <div class="step <?php echo $step >= 2 ? 'active' : ''; ?> <?php echo $step > 2 ? 'completed' : ''; ?>">
                <div class="step-number">2</div>
                <span>Requirements</span>
            </div>
            <div class="step <?php echo $step >= 3 ? 'active' : ''; ?> <?php echo $step > 3 ? 'completed' : ''; ?>">
                <div class="step-number">3</div>
                <span>Database</span>
            </div>
            <div class="step <?php echo $step >= 4 ? 'active' : ''; ?> <?php echo $step > 4 ? 'completed' : ''; ?>">
                <div class="step-number">4</div>
                <span>Configuration</span>
            </div>
            <div class="step <?php echo $step >= 5 ? 'active' : ''; ?>">
                <div class="step-number">5</div>
                <span>Complete</span>
            </div>
        </div>
        
        <div class="installer-content">
            <?php if ($error): ?>
                <div class="alert alert-error">
                    <i class="fas fa-exclamation-circle"></i> <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>
            
            <?php if ($success): ?>
                <div class="alert alert-success">
                    <i class="fas fa-check-circle"></i> <?php echo htmlspecialchars($success); ?>
                </div>
            <?php endif; ?>
            
            <?php
            switch ($step) {
                case 1:
                    include 'steps/welcome.php';
                    break;
                case 2:
                    include 'steps/requirements.php';
                    break;
                case 3:
                    include 'steps/database.php';
                    break;
                case 4:
                    include 'steps/configuration.php';
                    break;
                case 5:
                    include 'steps/complete.php';
                    break;
            }
            ?>
        </div>
    </div>
</body>
</html>