<?php
/**
 * AI App Generator - Main Entry Point
 * Compatible with shared hosting environments
 * 
 * @author MiniMax Agent
 * @version 1.0
 */

// Start session
session_start();

// Include configuration
require_once 'config/config.php';
require_once 'includes/functions.php';
require_once 'includes/ai-generator.php';

// Check if installation is complete
if (!is_installation_complete()) {
    header('Location: install/index.php');
    exit;
}

// Handle different pages
$page = $_GET['page'] ?? 'dashboard';
$action = $_GET['action'] ?? '';

// Route requests
switch ($page) {
    case 'dashboard':
        if (!is_logged_in()) {
            header('Location: auth/login.php');
            exit;
        }
        include 'pages/dashboard.php';
        break;
        
    case 'generator':
        if (!is_logged_in()) {
            header('Location: auth/login.php');
            exit;
        }
        include 'pages/generator.php';
        break;
        
    case 'projects':
        if (!is_logged_in()) {
            header('Location: auth/login.php');
            exit;
        }
        include 'pages/projects.php';
        break;
        
    case 'templates':
        if (!is_logged_in()) {
            header('Location: auth/login.php');
            exit;
        }
        include 'pages/templates.php';
        break;
        
    case 'export':
        if (!is_logged_in()) {
            header('Location: auth/login.php');
            exit;
        }
        include 'pages/export.php';
        break;
        
    case 'settings':
        if (!is_logged_in()) {
            header('Location: auth/login.php');
            exit;
        }
        include 'pages/settings.php';
        break;
        
    case 'auth':
        include "auth/{$action}.php";
        break;
        
    case 'api':
        // Handle AJAX requests
        include 'api/index.php';
        break;
        
    default:
        include 'pages/home.php';
        break;
}
?>