<?php
/**
 * Header Template
 * Common header for all pages
 */

if (!is_logged_in()) {
    header('Location: auth/login.php');
    exit;
}

$user = get_user_by_id(get_current_user_id());
$current_page = $_GET['page'] ?? 'dashboard';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo htmlspecialchars(APP_NAME); ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            line-height: 1.6;
            color: #111827;
            background: #F8FAFC;
        }

        /* Navigation */
        .navbar {
            background: white;
            border-bottom: 1px solid #E5E7EB;
            position: sticky;
            top: 0;
            z-index: 1000;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }

        .nav-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
            display: flex;
            justify-content: space-between;
            align-items: center;
            height: 70px;
        }

        .nav-brand {
            display: flex;
            align-items: center;
            gap: 0.75rem;
        }

        .nav-brand h1 {
            color: #3B82F6;
            font-size: 1.5rem;
            font-weight: 700;
        }

        .nav-brand i {
            color: #3B82F6;
            font-size: 1.75rem;
        }

        .nav-menu {
            display: flex;
            list-style: none;
            gap: 2rem;
            align-items: center;
        }

        .nav-menu a {
            text-decoration: none;
            color: #6B7280;
            font-weight: 500;
            padding: 0.5rem 1rem;
            border-radius: 6px;
            transition: all 0.3s;
        }

        .nav-menu a:hover,
        .nav-menu a.active {
            color: #3B82F6;
            background: #EBF8FF;
        }

        .user-menu {
            position: relative;
        }

        .user-avatar {
            width: 40px;
            height: 40px;
            background: linear-gradient(135deg, #3B82F6, #1D4ED8);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: 600;
            cursor: pointer;
            position: relative;
        }

        .user-avatar::after {
            content: attr(data-initials);
        }

        .dropdown-menu {
            position: absolute;
            right: 0;
            top: 100%;
            background: white;
            border: 1px solid #E5E7EB;
            border-radius: 8px;
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
            min-width: 200px;
            padding: 0.5rem 0;
            display: none;
            z-index: 1001;
        }

        .dropdown-menu.show {
            display: block;
        }

        .dropdown-menu a {
            display: flex;
            align-items: center;
            gap: 0.75rem;
            padding: 0.75rem 1rem;
            color: #374151;
            text-decoration: none;
            transition: background 0.3s;
        }

        .dropdown-menu a:hover {
            background: #F9FAFB;
        }

        .dropdown-divider {
            height: 1px;
            background: #E5E7EB;
            margin: 0.5rem 0;
        }

        /* Mobile Menu */
        .mobile-menu-toggle {
            display: none;
            background: none;
            border: none;
            font-size: 1.5rem;
            color: #6B7280;
            cursor: pointer;
        }

        .mobile-menu {
            display: none;
            background: white;
            border-top: 1px solid #E5E7EB;
            padding: 1rem 0;
        }

        .mobile-menu a {
            display: block;
            padding: 0.75rem 1rem;
            color: #6B7280;
            text-decoration: none;
            border-left: 3px solid transparent;
        }

        .mobile-menu a:hover,
        .mobile-menu a.active {
            color: #3B82F6;
            background: #EBF8FF;
            border-left-color: #3B82F6;
        }

        /* Notifications */
        .notification {
            position: fixed;
            top: 80px;
            right: 20px;
            background: white;
            border: 1px solid #E5E7EB;
            border-radius: 8px;
            padding: 1rem;
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
            max-width: 400px;
            z-index: 1002;
            transform: translateX(100%);
            transition: transform 0.3s ease;
        }

        .notification.show {
            transform: translateX(0);
        }

        .notification.success {
            border-left: 4px solid #10B981;
        }

        .notification.error {
            border-left: 4px solid #EF4444;
        }

        .notification.info {
            border-left: 4px solid #3B82F6;
        }

        .notification-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 0.5rem;
        }

        .notification-title {
            font-weight: 600;
            color: #111827;
        }

        .notification-close {
            background: none;
            border: none;
            color: #6B7280;
            cursor: pointer;
            font-size: 1.25rem;
        }

        .notification-message {
            color: #6B7280;
            line-height: 1.5;
        }

        /* Loading Overlay */
        .loading-overlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255,255,255,0.9);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }

        .loading-spinner {
            width: 50px;
            height: 50px;
            border: 3px solid #E5E7EB;
            border-top: 3px solid #3B82F6;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }

        /* Responsive */
        @media (max-width: 768px) {
            .nav-menu {
                display: none;
            }

            .mobile-menu-toggle {
                display: block;
            }

            .mobile-menu.show {
                display: block;
            }

            .notification {
                left: 20px;
                right: 20px;
                max-width: none;
            }
        }
    </style>
</head>
<body>
    <!-- Navigation -->
    <nav class="navbar">
        <div class="nav-container">
            <div class="nav-brand">
                <i class="fas fa-magic"></i>
                <h1><?php echo htmlspecialchars(APP_NAME); ?></h1>
            </div>

            <ul class="nav-menu">
                <li><a href="?page=dashboard" class="<?php echo $current_page === 'dashboard' ? 'active' : ''; ?>">
                    <i class="fas fa-home"></i> Dashboard
                </a></li>
                <li><a href="?page=generator" class="<?php echo $current_page === 'generator' ? 'active' : ''; ?>">
                    <i class="fas fa-plus-circle"></i> Create
                </a></li>
                <li><a href="?page=templates" class="<?php echo $current_page === 'templates' ? 'active' : ''; ?>">
                    <i class="fas fa-template"></i> Templates
                </a></li>
                <li><a href="?page=projects" class="<?php echo $current_page === 'projects' ? 'active' : ''; ?>">
                    <i class="fas fa-folder"></i> Projects
                </a></li>
                <li><a href="?page=settings" class="<?php echo $current_page === 'settings' ? 'active' : ''; ?>">
                    <i class="fas fa-cog"></i> Settings
                </a></li>
            </ul>

            <div class="user-menu">
                <div class="user-avatar" data-initials="<?php echo get_user_initials($user); ?>" onclick="toggleUserMenu()"></div>
                <div class="dropdown-menu" id="userMenu">
                    <div style="padding: 1rem; border-bottom: 1px solid #E5E7EB;">
                        <div style="font-weight: 600;"><?php echo htmlspecialchars($user['name'] ?? $user['email']); ?></div>
                        <div style="color: #6B7280; font-size: 0.875rem;"><?php echo htmlspecialchars($user['email']); ?></div>
                    </div>
                    <a href="?page=settings">
                        <i class="fas fa-user-cog"></i> Account Settings
                    </a>
                    <a href="?page=settings&tab=security">
                        <i class="fas fa-shield-alt"></i> Security
                    </a>
                    <div class="dropdown-divider"></div>
                    <a href="auth/logout.php" onclick="return confirm('Are you sure you want to logout?')">
                        <i class="fas fa-sign-out-alt"></i> Logout
                    </a>
                </div>
            </div>

            <button class="mobile-menu-toggle" onclick="toggleMobileMenu()">
                <i class="fas fa-bars"></i>
            </button>
        </div>

        <div class="mobile-menu" id="mobileMenu">
            <a href="?page=dashboard" class="<?php echo $current_page === 'dashboard' ? 'active' : ''; ?>">
                <i class="fas fa-home"></i> Dashboard
            </a>
            <a href="?page=generator" class="<?php echo $current_page === 'generator' ? 'active' : ''; ?>">
                <i class="fas fa-plus-circle"></i> Create
            </a>
            <a href="?page=templates" class="<?php echo $current_page === 'templates' ? 'active' : ''; ?>">
                <i class="fas fa-template"></i> Templates
            </a>
            <a href="?page=projects" class="<?php echo $current_page === 'projects' ? 'active' : ''; ?>">
                <i class="fas fa-folder"></i> Projects
            </a>
            <a href="?page=settings" class="<?php echo $current_page === 'settings' ? 'active' : ''; ?>">
                <i class="fas fa-cog"></i> Settings
            </a>
        </div>
    </nav>

    <!-- Loading Overlay -->
    <div class="loading-overlay" id="loadingOverlay" style="display: none;">
        <div class="loading-spinner"></div>
    </div>

    <script>
        // User menu toggle
        function toggleUserMenu() {
            const menu = document.getElementById('userMenu');
            menu.classList.toggle('show');
        }

        // Mobile menu toggle
        function toggleMobileMenu() {
            const menu = document.getElementById('mobileMenu');
            menu.classList.toggle('show');
        }

        // Close dropdowns when clicking outside
        document.addEventListener('click', function(event) {
            const userMenu = document.getElementById('userMenu');
            const userAvatar = document.querySelector('.user-avatar');
            const mobileMenu = document.getElementById('mobileMenu');
            const mobileToggle = document.querySelector('.mobile-menu-toggle');

            if (!userAvatar.contains(event.target) && !userMenu.contains(event.target)) {
                userMenu.classList.remove('show');
            }

            if (!mobileToggle.contains(event.target) && !mobileMenu.contains(event.target)) {
                mobileMenu.classList.remove('show');
            }
        });

        // Notification system
        function showNotification(message, type = 'info', title = '') {
            const notification = document.createElement('div');
            notification.className = `notification ${type}`;
            notification.innerHTML = `
                <div class="notification-header">
                    <div class="notification-title">${title || type.charAt(0).toUpperCase() + type.slice(1)}</div>
                    <button class="notification-close" onclick="this.parentElement.parentElement.remove()">&times;</button>
                </div>
                <div class="notification-message">${message}</div>
            `;

            document.body.appendChild(notification);

            // Show notification
            setTimeout(() => notification.classList.add('show'), 100);

            // Auto hide after 5 seconds
            setTimeout(() => {
                notification.classList.remove('show');
                setTimeout(() => notification.remove(), 300);
            }, 5000);
        }

        // Loading overlay
        function showLoading() {
            document.getElementById('loadingOverlay').style.display = 'flex';
        }

        function hideLoading() {
            document.getElementById('loadingOverlay').style.display = 'none';
        }

        // CSRF token for AJAX requests
        const csrfToken = '<?php echo generate_csrf_token(); ?>';
    </script>