<?php
/**
 * Login Page
 * User authentication
 */

session_start();

// Redirect if already logged in
if (is_logged_in()) {
    header('Location: ../index.php?page=dashboard');
    exit;
}

$error = $_GET['error'] ?? '';
$message = $_GET['message'] ?? '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = sanitize_input($_POST['email'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if (empty($email) || empty($password)) {
        $error = "Please enter both email and password";
    } else {
        // Attempt login
        global $db;
        try {
            $stmt = $db->query("SELECT * FROM users WHERE email = ? AND is_active = 1", [$email]);
            $user = $stmt->fetch();
            
            if ($user && verify_password($password, $user['password'])) {
                // Login successful
                $_SESSION['user_id'] = $user['id'];
                $_SESSION['user_email'] = $user['email'];
                $_SESSION['user_name'] = $user['name'];
                
                // Update last login
                $db->query("UPDATE users SET last_login = NOW() WHERE id = ?", [$user['id']]);
                
                header('Location: ../index.php?page=dashboard');
                exit;
            } else {
                $error = "Invalid email or password";
            }
        } catch (Exception $e) {
            $error = "Login failed. Please try again.";
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - <?php echo htmlspecialchars(APP_NAME); ?></title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', -apple-system, BlinkMacSystemFont, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #333;
        }

        .login-container {
            background: white;
            border-radius: 20px;
            box-shadow: 0 25px 50px rgba(0,0,0,0.15);
            max-width: 450px;
            width: 90%;
            overflow: hidden;
        }

        .login-header {
            background: linear-gradient(135deg, #3B82F6, #1D4ED8);
            color: white;
            padding: 3rem 2rem;
            text-align: center;
        }

        .login-header i {
            font-size: 3rem;
            margin-bottom: 1rem;
        }

        .login-header h1 {
            font-size: 2rem;
            margin-bottom: 0.5rem;
            font-weight: 700;
        }

        .login-header p {
            opacity: 0.9;
        }

        .login-form {
            padding: 2rem;
        }

        .alert {
            padding: 1rem;
            border-radius: 8px;
            margin-bottom: 1.5rem;
        }

        .alert-error {
            background: #FEE2E2;
            color: #991B1B;
            border: 1px solid #FECACA;
        }

        .alert-info {
            background: #DBEAFE;
            color: #1E40AF;
            border: 1px solid #93C5FD;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-group label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 500;
            color: #374151;
        }

        .form-group input {
            width: 100%;
            padding: 0.75rem 1rem;
            border: 2px solid #D1D5DB;
            border-radius: 10px;
            font-size: 1rem;
            transition: all 0.3s;
            background: #F9FAFB;
        }

        .form-group input:focus {
            outline: none;
            border-color: #3B82F6;
            background: white;
        }

        .btn {
            width: 100%;
            padding: 1rem;
            border: none;
            border-radius: 10px;
            font-size: 1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 0.5rem;
        }

        .btn-primary {
            background: linear-gradient(135deg, #3B82F6, #1D4ED8);
            color: white;
        }

        .btn-primary:hover {
            background: linear-gradient(135deg, #1D4ED8, #1E40AF);
            transform: translateY(-2px);
        }

        .login-footer {
            text-align: center;
            padding: 1.5rem 2rem;
            background: #F8FAFC;
            color: #6B7280;
            font-size: 0.875rem;
        }

        .login-footer a {
            color: #3B82F6;
            text-decoration: none;
            font-weight: 500;
        }

        .login-footer a:hover {
            text-decoration: underline;
        }

        .features {
            margin-top: 1.5rem;
            padding: 1rem;
            background: #F8FAFC;
            border-radius: 10px;
            font-size: 0.875rem;
        }

        .features h4 {
            color: #374151;
            margin-bottom: 0.5rem;
            font-size: 0.9rem;
        }

        .features ul {
            list-style: none;
            color: #6B7280;
        }

        .features li {
            padding: 0.25rem 0;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .features li i {
            color: #10B981;
        }

        @media (max-width: 480px) {
            .login-container {
                margin: 1rem;
            }
            
            .login-header {
                padding: 2rem 1rem;
            }
            
            .login-form {
                padding: 1.5rem;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-header">
            <i class="fas fa-magic"></i>
            <h1>Welcome Back</h1>
            <p>Sign in to your AI App Generator account</p>
        </div>

        <div class="login-form">
            <?php if ($error): ?>
                <div class="alert alert-error">
                    <i class="fas fa-exclamation-circle"></i> <?php echo htmlspecialchars($error); ?>
                </div>
            <?php endif; ?>

            <?php if ($message): ?>
                <div class="alert alert-info">
                    <i class="fas fa-info-circle"></i> <?php echo htmlspecialchars($message); ?>
                </div>
            <?php endif; ?>

            <form method="POST">
                <div class="form-group">
                    <label for="email">
                        <i class="fas fa-envelope"></i> Email Address
                    </label>
                    <input type="email" id="email" name="email" 
                           value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>" 
                           placeholder="Enter your email" required>
                </div>

                <div class="form-group">
                    <label for="password">
                        <i class="fas fa-lock"></i> Password
                    </label>
                    <input type="password" id="password" name="password" 
                           placeholder="Enter your password" required>
                </div>

                <button type="submit" class="btn btn-primary">
                    <i class="fas fa-sign-in-alt"></i> Sign In
                </button>
            </form>

            <div class="features">
                <h4><i class="fas fa-star"></i> What you can do:</h4>
                <ul>
                    <li><i class="fas fa-check"></i> Create web applications with AI</li>
                    <li><i class="fas fa-check"></i> Browse pre-built templates</li>
                    <li><i class="fas fa-check"></i> Export and deploy anywhere</li>
                    <li><i class="fas fa-check"></i> Manage your projects</li>
                </ul>
            </div>
        </div>

        <div class="login-footer">
            <p>Don't have an account? The admin will create accounts during installation.</p>
            <p style="margin-top: 1rem;">
                <a href="register.php">Need help?</a> | 
                <a href="reset-password.php">Forgot password?</a>
            </p>
        </div>
    </div>

    <script>
        // Auto-focus email field
        document.getElementById('email').focus();
    </script>
</body>
</html>