<?php
/**
 * File Download Handler
 */

session_start();
require_once '../config/config.php';

if (!is_logged_in()) {
    header('Location: ../auth/login.php');
    exit;
}

$filename = $_GET['file'] ?? '';
$temp_dir = sys_get_temp_dir();

if (empty($filename) || !file_exists($temp_dir . '/' . $filename)) {
    http_response_code(404);
    echo "File not found";
    exit;
}

$file_path = $temp_dir . '/' . $filename;

if (pathinfo($filename, PATHINFO_EXTENSION) !== 'zip') {
    http_response_code(400);
    echo "Invalid file type";
    exit;
}

// Set headers for download
header('Content-Type: application/zip');
header('Content-Disposition: attachment; filename="' . $filename . '"');
header('Content-Length: ' . filesize($file_path));
header('Cache-Control: no-cache, must-revalidate');
header('Expires: 0');

// Output file
readfile($file_path);

// Clean up temp file
unlink($file_path);

exit;
?>