# AI App Generator

A powerful web application that allows users to create full-stack web applications using artificial intelligence. Simply describe what you want to build, and our AI will generate a complete, ready-to-deploy website or web app.

## Features

- 🤖 **AI-Powered Generation**: Create web applications using natural language descriptions
- 📱 **Responsive Design**: All generated apps work perfectly on mobile and desktop
- 🎨 **Multiple App Types**: E-commerce, blogs, portfolios, dashboards, business websites, and more
- 📋 **Pre-built Templates**: Quick start with professionally designed templates
- 📁 **Project Management**: Save, edit, and manage multiple projects
- 📦 **Easy Export**: Download your generated apps as ZIP files for deployment
- 🔐 **Secure Authentication**: User accounts with secure login system
- 📊 **Analytics Dashboard**: Track your projects and usage
- 🌐 **Universal Compatibility**: Works with any shared hosting provider

## Requirements

### Server Requirements
- PHP 7.4 or higher
- MySQL 5.7+ or MariaDB 10.2+
- Minimum 256MB RAM
- 50MB disk space (additional space for generated projects)
- mod_rewrite enabled (for clean URLs)

### PHP Extensions Required
- mysqli
- pdo_mysql
- json
- curl
- gd
- zip

### Hosting Compatibility
- cPanel hosting
- Shared hosting
- VPS/Dedicated servers
- WordPress hosting (works alongside WordPress)

## Installation Guide

### Step 1: Download and Upload
1. Download all files from this project
2. Upload the entire `ai-app-generator` folder to your web hosting
3. Ensure the folder is accessible via your domain (e.g., `yoursite.com/ai-app-generator/`)

### Step 2: Run Installation Wizard
1. Visit your installation URL (e.g., `yoursite.com/ai-app-generator/install/`)
2. Follow the step-by-step installation wizard:
   - **Step 1**: Welcome and overview
   - **Step 2**: System requirements check
   - **Step 3**: Database configuration
   - **Step 4**: Admin account and settings
   - **Step 5**: Installation complete

### Step 3: Database Setup
1. Create a new MySQL database in your hosting control panel
2. Create a database user with full privileges
3. Add the user to your database
4. Enter the database credentials in the installation wizard

### Step 4: Admin Account
1. Create your admin account with:
   - Email address
   - Secure password
   - Site name
   - AI API configuration

### Step 5: AI Configuration
Choose from three AI providers:
- **OpenAI**: Most powerful, requires API key
- **Anthropic Claude**: Alternative option
- **Mock AI**: Test without API key (limited functionality)

## Configuration

### Database Configuration
Update `config/config.php` with your database settings:
```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'your_database_name');
define('DB_USER', 'your_db_username');
define('DB_PASS', 'your_db_password');
```

### AI API Configuration
Add your AI API keys:
```php
define('OPENAI_API_KEY', 'your-openai-api-key-here');
define('CLAUDE_API_KEY', 'your-claude-api-key-here');
define('DEFAULT_AI_PROVIDER', 'openai');
```

### Email Configuration
Configure SMTP for notifications:
```php
define('SMTP_HOST', 'your-smtp-host');
define('SMTP_USER', 'your-email@domain.com');
define('SMTP_PASS', 'your-email-password');
```

## Usage

### Creating Your First App
1. **Login**: Go to your installation URL and login
2. **Navigate to Generator**: Click "Create" in the main menu
3. **Choose Template**: Select a pre-built template or start from scratch
4. **Describe Your App**: Write a detailed description of what you want
5. **Select Features**: Choose additional features (login, search, etc.)
6. **Generate**: Click "Generate Application" and wait for AI to create your app
7. **Export**: Download your completed app as a ZIP file

### Example Descriptions
**E-commerce Store**:
```
Create a modern e-commerce store with product catalog, shopping cart, and checkout. 
Use a clean, professional design with blue and white colors. Include user registration, 
product search, payment integration, and order management.
```

**Portfolio Website**:
```
Build a personal portfolio website showcasing my web design and development work. 
Include project gallery, about section, contact form, and social media links. 
Use a modern, minimalist design with dark theme.
```

**Business Dashboard**:
```
Create a business dashboard for tracking sales, customers, and inventory. 
Include charts, tables, user management, and role-based access. 
Use a professional design with data visualization.
```

### Managing Projects
- **View All Projects**: Browse and manage all your generated applications
- **Edit Projects**: Modify and regenerate specific parts of your app
- **Export Projects**: Download projects for deployment
- **Delete Projects**: Remove projects you no longer need

### Templates Available
- E-commerce Store
- Blog/News Website
- Portfolio Website
- Business Website
- Admin Dashboard
- Landing Page
- Restaurant Website
- Personal Website

## Deployment Guide

### After Generating Your App
1. **Download**: Click "Export" in your project to download a ZIP file
2. **Extract**: Unzip the downloaded file to see all your app files
3. **Upload**: Upload all files to your preferred hosting provider
4. **Configure**: Set up database and environment settings as needed

### Popular Hosting Providers
- **Shared Hosting**: cPanel, HostGator, Bluehost, SiteGround
- **Cloud Hosting**: Netlify, Vercel, Cloudflare Pages
- **WordPress Hosting**: Works alongside existing WordPress installations
- **Custom Hosting**: Any web server with PHP support

### File Structure
Generated apps include:
- `index.html` - Main entry point
- `pages/` - Additional pages
- `assets/css/style.css` - Stylesheet
- `assets/js/app.js` - JavaScript functionality
- `config.json` - App configuration
- `README.md` - Instructions and documentation

## AI Integration

### OpenAI Integration
1. Get API key from [OpenAI Platform](https://platform.openai.com/api-keys)
2. Add key to configuration: `OPENAI_API_KEY`
3. Choose "OpenAI" as your provider
4. Monitor usage in your OpenAI account

### Anthropic Claude Integration
1. Get API key from [Anthropic Console](https://console.anthropic.com/)
2. Add key to configuration: `CLAUDE_API_KEY`
3. Choose "Claude" as your provider
4. Monitor usage in your Anthropic account

### Mock AI (For Testing)
- Works without API keys
- Generates basic app structures
- Limited functionality
- Good for testing and demonstrations

## Troubleshooting

### Common Issues

**Database Connection Failed**
- Check database credentials in config.php
- Ensure database exists and user has permissions
- Verify MySQL server is running

**AI Generation Fails**
- Verify API key is correct and active
- Check API key has sufficient credits
- Ensure internet connection for API calls

**File Upload Fails**
- Check server file permissions (755 for folders, 644 for files)
- Verify PHP upload limits
- Check available disk space

**Login Issues**
- Clear browser cookies and session data
- Check if session path is writable
- Verify user exists in database

### Performance Optimization
- Enable PHP OPcache
- Use a CDN for static assets
- Optimize database queries
- Enable gzip compression
- Use image optimization

### Security Best Practices
- Enable SSL/HTTPS
- Regular security updates
- Strong password requirements
- Regular database backups
- Monitor file permissions
- Use security headers

## Support

### Getting Help
1. Check the troubleshooting section above
2. Review server error logs
3. Verify all requirements are met
4. Test with a fresh installation

### Common Error Messages
- "Database connection failed" - Check database settings
- "AI generation failed" - Verify API key and credits
- "Permission denied" - Check file/folder permissions
- "Session error" - Check PHP session configuration

## Technical Details

### Architecture
- **Frontend**: Modern HTML5, CSS3, JavaScript
- **Backend**: PHP 7.4+
- **Database**: MySQL/MariaDB
- **AI Integration**: RESTful API calls
- **Authentication**: Session-based with password hashing

### Database Schema
- `users` - User accounts and authentication
- `projects` - Generated application metadata
- `project_files` - Individual file storage
- `templates` - Pre-built application templates
- `generation_logs` - AI generation tracking
- `settings` - Application configuration
- `sessions` - User session management

### File Structure
```
ai-app-generator/
├── index.php              # Main entry point
├── config/                # Configuration files
├── includes/              # Core functions
├── pages/                 # Application pages
├── auth/                  # Authentication
├── api/                   # AJAX endpoints
├── install/               # Installation wizard
├── database/              # Database schema
├── uploads/               # User uploads
├── projects/              # Generated projects
├── templates/             # App templates
└── logs/                  # Application logs
```

## License

This project is open source and available under the MIT License.

## Credits

Built with:
- PHP for backend logic
- MySQL for data storage
- AI APIs (OpenAI, Anthropic) for generation
- Modern web technologies for responsive design
- Font Awesome for icons
- Inter font for typography

---

## Quick Start Summary

1. **Upload** files to your web hosting
2. **Run** the installation wizard at `/install/`
3. **Create** admin account and configure AI
4. **Generate** your first app with AI
5. **Export** and deploy your application

That's it! You now have a fully functional AI App Generator running on your shared hosting environment.